<?php

/**
 * @file media_akamai/includes/themes/media-akamai-video.tpl.php
 *
 * Template file for theme('media_akamai_video').
 *
 * Variables available:
 *  $uri - The uri to the Akamai video, such as akamai://v/xsy7x8c9.
 *  $video_id - The unique identifier of the Akamai video.
 *  $width - The width to render.
 *  $height - The height to render.
 *  $autoplay - If TRUE, then start the player automatically when displaying.
 *  $fullscreen - Whether to allow fullscreen playback.
 *
 * Note that we set the width & height of the outer wrapper manually so that
 * the JS will respect that when resizing later.
 */
?>
<div class="media-akamai-outer-wrapper" id="media-akamai-<?php print $id; ?>" style="width: <?php print $width; ?>px; height: <?php print $height; ?>px;">
  <div class="media-akamai-preview-wrapper" id="<?php print $wrapper_id; ?>">
    <?php print $output; ?>
  </div>
</div>
