var hasCookiePlugin = false;//(typeof window.$.cookie == 'function'); //wapi is needed
jQuery.noConflict();
jQuery(document).ready(function($){
	var html = Drupal.settings.wconsole.content;
	$("body").append(html);
	if (hasCookiePlugin)
	{
		var pos = {};
		pos.top = $.cookie("wconsole_pos_top");
		pos.left = $.cookie("wconsole_pos_left");
		
		pos.top = (isNaN(pos.top) || pos.top==null)?20:pos.top;
		pos.left = (isNaN(pos.left) || pos.left==null)?0:pos.left;
		
		$(".wconsole-block").css({"top":pos.top+"px","left":pos.left+"px"});
		
		var wswitch = $.cookie("wconsole_switch");
		if (wswitch == "is_close")
		{
			var $a = $(".wconsole-block .switch a");
			$a.toggleClass("open");
			$a.html("open");
			$a.attr("title","open");				
			$(".wconsole-block .content").hide();
		}
			
		
	}
	
	if (Drupal.settings.wconsole.has_jquery_ui)
	{

		$(".wconsole-block h2").css({"cursor":"move"});
		$(".wconsole-block").draggable({
			cursor:'move',
			handle:"h2",
			opacity:0.7,
			helper:"original",
			zIndex:998,
			stop: function(event,ui){

				if (hasCookiePlugin)
				{
					var pos = $(".wconsole-block").offset();
					var height = $(window).height() - $(".wconsole-block").height();
					
					$.cookie("wconsole_pos_top",pos.top%height,{path:"/"});
					$.cookie("wconsole_pos_left",pos.left,{path:"/"});
				}
			}
		});
		$(".wconsole-block").resizable({
			stop:function (event,ui){
				alert("stop");
			}
		});
	}

	/*alert($.cookie("example"));
	
	$.cookie("example","this is an example");*/
	$(".wconsole-block").fadeIn();
	
	$(".wconsole-block .switch a").click(function(ev){
		ev.preventDefault();
		$a = $(this); 
		$(this).parent().siblings(".content").toggle("slow",function(){

			$a.toggleClass("open");
			
			if ($a.hasClass("open"))
			{
				$a.html("open");
				$a.attr("title","open");
				if (hasCookiePlugin)
					$.cookie("wconsole_switch","is_close",{path:"/"});
			}
			else
			{
				$a.html("close");
				$a.attr("title","close");
				if (hasCookiePlugin)
					$.cookie("wconsole_switch","is_open",{path:"/"});
				
			}
			
			
		});
			
	});
});