<?php 

function wpagetags_admin_default_settings($form_state){
    global $language;
    
    $pagetags_settings = unserialize(variable_get('wpagetags_setting','s:0'));
    $default_values = $pagetags_settings['default'][$language->language];
    
    $form = array();
    $form['intro'] = array(
        '#markup' => '<p>Here you may set the default Page tags for current language.
         If set to none the tag will use the default value, if any, else it won\'t be displayed. To change the tags for another language please visit this page with that as active. </p>'
    );
    $form['fields'] = array(
        '#type' => 'fieldset',
    );
    $form['fields']['ogimage'] = array(
      '#type' => 'textfield',
      '#title' => t('Open Graph Image'),
      '#description' => 'The image of the page as it appears on facebook. Don\'t use an absolute path',
      '#default_value' => $default_values['ogimage'],
      '#maxlength' => 128,
    );
    
    $form['fields']['twitter_account'] = array(
      '#type' => 'textfield',
      '#title' => t('Twitter Account'),
      '#default_value' => $default_values['twitter_account'],
      '#maxlength' => 128,
    );
    $form['op'] = array(
        '#value' => t('Submit'),
        '#type' => 'submit', 
    );
    return $form;
}

function wpagetags_admin_default_settings_submit($form, &$form_state) {
  global $language;
    
  $pagetags_settings = unserialize(variable_get('wpagetags_setting','s:0'));
  $pagetags_settings['default'][$language->language] = array();
  foreach($form['fields'] as $field_name => $field){
      if(strpos($field_name,'#')!==0 && strlen(trim($field['#value']))){
          $pagetags_settings['default'][$language->language][$field_name] = trim($field['#value']);
      }
  }
  variable_set('wpagetags_setting',serialize($pagetags_settings));
  drupal_set_message('The default page tags were succefully updated');
  
}

function wpagetags_admin_node_settings($form_state){
    global $language;
    
    $pagetags_settings = unserialize(variable_get('wpagetags_setting','s:0'));
    $default_values = $pagetags_settings['node'][$language->language];
    $node_types = node_type_get_types();
    $form = array();
    $form['intro'] = array(
        '#markup' => '<p>Here you may set the default Page tags values for each content type in current language.
         If set to none the tag will use the default value, if any, else it won\'t be displayed. To change the tags for another language please visit this page with that as active. </p>'
    );
    $form['fields'] = array(
      '#prefix' => '<table><thead><tr><th>Content Type</th><th>Page Title</th><th>Description</th><th>Keywords</th><th>Open Graph Title</th><th>Open Graph Image</th></tr></thead><tbody>',
      '#suffix'=> '</tbody></table>',
    );
    foreach($node_types as $node_type){
        $fields = field_info_instances("node",$node_type->type);
        $media_fields = array('none' => '<None>');
        $text_fields = array('none' => '<None>', 'title' => 'Node Title');
        $text_area_fields = array('none' => '<None>');
        $taxonomy_fields = array();
        foreach($fields as $field_name => $field){
            if(in_array($field['widget']['module'], array('image','media','media_multiselect'))) $media_fields[$field_name] = $field['label'];
            else if($field['widget']['module']=='taxonomy' || $field['display']['token']['module']=='taxonomy') $taxonomy_fields[$field_name] = $field['label'];
            else if($field['widget']['module']=='text') {
                if($field['widget']['type']=='text_textfield') $text_fields[$field_name] = $field['label'];
                else $text_area_fields[$field_name] = $field['label'];
            }
        }
        
        $form['fields'][$node_type->type.'_name'] = array(
            '#markup' => '<strong>'.$node_type->name.'</strong>',
            '#prefix' => '<tr><td>',
            '#suffix' => '</td>'
        );
        
        $form['fields'][$node_type->type.'_title'] = array(
            '#type' => 'select',
            '#options' => $text_fields,
            '#default_value' => $default_values[$node_type->type]['title'],
            '#prefix' => '<td>',
            '#suffix' => '</td>',
            '#attributes' => array('style'=> 'width:90%;','ct'=>$node_type->type, 'fn' =>'title')
        );
        
        $form['fields'][$node_type->type.'_description'] = array(
            '#type' => 'select',
            '#options' => $text_area_fields,
            '#default_value' => $default_values[$node_type->type]['description'],
            '#prefix' => '<td>',
            '#suffix' => '</td>',
            '#attributes' => array('style'=> 'width:90%;','ct'=>$node_type->type, 'fn' =>'description')
        );
        
        $form['fields'][$node_type->type.'_keywords'] = array(
            '#type' => 'select',
            '#options' => array_merge($text_fields,$taxonomy_fields),
            '#default_value' => $default_values[$node_type->type]['keywords'],
            '#prefix' => '<td>',
            '#suffix' => '</td>',
            '#attributes' => array('style'=> 'width:90%;','ct'=>$node_type->type, 'fn' =>'keywords')
        );
        
        $form['fields'][$node_type->type.'_ogtitle'] = array(
            '#type' => 'select',
            '#options' => $text_fields,
            '#default_value' => $default_values[$node_type->type]['ogtitle'],
            '#prefix' => '<td>',
            '#suffix' => '</td>',
            '#attributes' => array('style'=> 'width:90%;','ct'=>$node_type->type, 'fn' =>'ogtitle')
        );
        
        $form['fields'][$node_type->type.'_ogimage'] = array(
            '#type' => 'select',
            '#options' => $media_fields,
            '#default_value' => $default_values[$node_type->type]['ogimage'],
            '#prefix' => '<td>',
            '#suffix' => '</td></tr>',
            '#attributes' => array('style'=> 'width:90%;','ct'=>$node_type->type, 'fn' =>'ogimage')
        );
    }
    
    $form['op'] = array(
        '#value' => t('Submit'),
        '#type' => 'submit', 
    );
    return $form;
}

function wpagetags_admin_node_settings_submit($form, &$form_state) {
  global $language;
    
  $pagetags_settings = unserialize(variable_get('wpagetags_setting','s:0'));
  $pagetags_settings['node'][$language->language] = array();
  foreach($form['fields'] as $field_name => $field){
      if(strpos($field_name,'#')!==0 && $field['#value']!='none' && $field['#attributes']['ct'] && $field['#attributes']['fn']){
          $pagetags_settings['node'][$language->language][$field['#attributes']['ct']][$field['#attributes']['fn']] = trim($field['#value']);
      }
  }

  variable_set('wpagetags_setting',serialize($pagetags_settings));
  drupal_set_message('The default content type page tags were succefully updated');
}

function wpagetags_admin_taxonomy_settings($form_state){
    global $language;
    
    $pagetags_settings = unserialize(variable_get('wpagetags_setting','s:0'));
    $default_values = $pagetags_settings['taxonomy'][$language->language];
    $taxonomy_types = taxonomy_get_vocabularies();
    $form = array();
    $form['intro'] = array(
        '#markup' => '<p>Here you may set the default Page tags values for each taxonomy in current language.
         If set to none the tag will use the default value, if any, else it won\'t be displayed. To change the tags for another language please visit this page with that as active. </p>'
    );
    $form['fields'] = array(
      '#prefix' => '<table><thead><tr><th>Taxonomy</th><th>Page Title</th><th>Description</th><th>Keywords</th><th>Open Graph Title</th><th>Open Graph Image</th></tr></thead><tbody>',
      '#suffix'=> '</tbody></table>',
    );
    foreach($taxonomy_types as $taxonomy){
        $fields = field_info_instances("taxonomy_term",$taxonomy->machine_name);
        $media_fields = array('none' => '<None>');
        $text_fields = array('none' => '<None>', 'title' => 'Title');
        $text_area_fields = array('none' => '<None>', 'description' => 'Description');
        $taxonomy_fields = array();
        foreach($fields as $field_name => $field){
            if(in_array($field['widget']['module'], array('image','media','media_multiselect'))) $media_fields[$field_name] = $field['label'];
            else if($field['widget']['module']=='taxonomy') $taxonomy_fields[$field_name] = $field['label'];
            else if($field['widget']['module']=='text') {
                if($field['widget']['type']=='text_textfield') $text_fields[$field_name] = $field['label'];
                else $text_area_fields[$field_name] = $field['label'];
            }
        }
        
        $form['fields'][$taxonomy->machine_name.'_name'] = array(
            '#markup' => '<strong>'.$taxonomy->name.'</strong>',
            '#prefix' => '<tr><td>',
            '#suffix' => '</td>'
        );
        
        $form['fields'][$taxonomy->machine_name.'_title'] = array(
            '#type' => 'select',
            '#options' => $text_fields,
            '#default_value' => $default_values[$taxonomy->machine_name]['title'],
            '#prefix' => '<td>',
            '#suffix' => '</td>',
            '#attributes' => array('style'=> 'width:90%;','ct'=>$taxonomy->machine_name, 'fn' =>'title')
        );
        
        $form['fields'][$taxonomy->machine_name.'_description'] = array(
            '#type' => 'select',
            '#options' => $text_area_fields,
            '#default_value' => $default_values[$taxonomy->machine_name]['description'],
            '#prefix' => '<td>',
            '#suffix' => '</td>',
            '#attributes' => array('style'=> 'width:90%;','ct'=>$taxonomy->machine_name, 'fn' =>'description')
        );
        
        $form['fields'][$taxonomy->machine_name.'_keywords'] = array(
            '#type' => 'select',
            '#options' => array_merge($text_fields,$taxonomy_fields),
            '#default_value' => $default_values[$taxonomy->machine_name]['keywords'],
            '#prefix' => '<td>',
            '#suffix' => '</td>',
            '#attributes' => array('style'=> 'width:90%;','ct'=>$taxonomy->machine_name, 'fn' =>'keywords')
        );
        
        $form['fields'][$taxonomy->machine_name.'_ogtitle'] = array(
            '#type' => 'select',
            '#options' => $text_fields,
            '#default_value' => $default_values[$taxonomy->machine_name]['ogtitle'],
            '#prefix' => '<td>',
            '#suffix' => '</td>',
            '#attributes' => array('style'=> 'width:90%;','ct'=>$taxonomy->machine_name, 'fn' =>'ogtitle')
        );
        
        $form['fields'][$taxonomy->machine_name.'_ogimage'] = array(
            '#type' => 'select',
            '#options' => $media_fields,
            '#default_value' => $default_values[$taxonomy->machine_name]['ogimage'],
            '#prefix' => '<td>',
            '#suffix' => '</td></tr>',
            '#attributes' => array('style'=> 'width:90%;','ct'=>$taxonomy->machine_name, 'fn' =>'ogimage')
        );
    }
    
    $form['op'] = array(
        '#value' => t('Submit'),
        '#type' => 'submit', 
    );
    return $form;
}

function wpagetags_admin_taxonomy_settings_submit($form, &$form_state) {
  global $language;
    
  $pagetags_settings = unserialize(variable_get('wpagetags_setting','s:0'));
  $pagetags_settings['taxonomy'][$language->language] = array();
  foreach($form['fields'] as $field_name => $field){
      if(strpos($field_name,'#')!==0 && $field['#value']!='none' && $field['#attributes']['ct'] && $field['#attributes']['fn']){
          $pagetags_settings['taxonomy'][$language->language][$field['#attributes']['ct']][$field['#attributes']['fn']] = trim($field['#value']);
      }
  }

  variable_set('wpagetags_setting',serialize($pagetags_settings));
  drupal_set_message('The default taxonomy page tags were succefully updated');
}


function wpagetags_admin_override(){
    
    $result  = db_query('SELECT * from wpagetags WHERE path = :path AND lang = :lang', array('path' => $_GET['path'], 'lang' => $_GET['lang']));
    
    if(!$record = $result->fetchAssoc()){
     $record = array(
        'title' => '',
        'description' =>'',
        'keywords' => '',
        'ogtitle' => '',
        'ogimage' => ''
     );
    }
    
    $form = array();
    $form['fields'] = array(
        '#type' => 'fieldset'
    );
    $form['fields']['title'] = array(
      '#type' => 'textfield',
      '#title' => t('Page Title'),
      '#description' => 'Page Title appearing on the browser window and as title on search results. Suggested max length: 8 words',
      '#default_value' => $record['pagetitle'],
      '#maxlength' => 128,
    );
    $form['fields']['description'] = array(
      '#type' => 'textarea',
      '#title' => t('Description'),
      '#description' => 'The page description appearing on both facebook and search engine. Suggested max length: 30 words',
      '#default_value' => $record['description'],
      '#rows' => 3,
      '#maxlength' => 300,
    );
    $form['fields']['keywords'] = array(
      '#type' => 'textfield',
      '#title' => t('Keywords'),
      '#description' => 'The page keywords for search engine indexing. Suggested max length: 10 keywords',
      '#default_value' => $record['keywords'],
      '#maxlength' => 128,
    );
    $form['fields']['ogtitle'] = array(
      '#type' => 'textfield',
      '#title' => t('Open Graph Title'),
      '#description' => 'The title of the page as it appears on facebook.  Suggested max length: 10 keywords',
     '#default_value' => $record['ogtitle'],
      '#maxlength' => 128,
    );
    $form['fields']['ogimage'] = array(
      '#type' => 'textfield',
      '#title' => t('Open Graph Image'),
      '#description' => 'The image of the page as it appears on facebook. Don\'t use an absolute path',
      '#default_value' => $record['ogimage'],
      '#maxlength' => 128,
    );
    $form['path'] = array('#type' => 'hidden', '#value' => $_GET['path']);
    $form['lang'] = array('#type' => 'hidden', '#value' => $_GET['lang']);
    $form['op'] = array(
        '#value' => t('Submit'),
        '#type' => 'submit', 
    );
    return $form;
}

function wpagetags_admin_override_submit($form, &$form_state) {
   $result  = db_query('SELECT * from wpagetags WHERE path = :path AND lang = :lang', array('path' => $_GET['path'], 'lang' => $_GET['lang']));
   if($record = $result->fetchObject()){
      $nid = $result->nid; 
       db_update('wpagetags')->fields(array(
        'pagetitle' => $form_state['values']['title'],
        'ogtitle' => $form_state['values']['ogtitle'],
        'description' => $form_state['values']['description'],
        'keywords' => $form_state['values']['keywords'],
        'ogimage' => $form_state['values']['ogimage'],
       ))
       ->condition('path',$form_state['values']['path'])
       ->condition('lang',$form_state['values']['lang'])
       ->execute();
   }else{
       db_insert('wpagetags')->fields(array(
        'path' => $form_state['values']['path'],
        'pagetitle' => $form_state['values']['title'],
        'ogtitle' => $form_state['values']['ogtitle'],
        'description' => $form_state['values']['description'],
        'keywords' => $form_state['values']['keywords'],
        'ogimage' => $form_state['values']['ogimage'],
        'lang' => $form_state['values']['lang'] 
       ))->execute();
   }
    drupal_set_message('Page Tags updated successfully');
}