<?php

/**
 * Here we override the default HTML output of drupal.
 * refer to http://drupal.org/node/550722
 */
 
function wedia_preprocess_page(&$vars, $hook) {
	if (isset($vars['node'])) {
		$node = &$vars['node'];
	}
	
	if (isset($vars['node_title'])) {
		$vars['title'] = $vars['node_title'];
	}
}

function wedia_preprocess_node(&$vars) {
	if (isset($vars['node'])) {
		$node = &$vars['node'];
	}

	if (!empty($node->classes_array)) {
		$vars['classes_array'] = array_merge($vars['classes_array'], $node->classes_array);
	}
}

function wedia_preprocess_block(&$vars, $hook) {
	// Add a striping class.
	$vars['classes_array'][] = 'block-' . $vars['block_zebra'];
}

/**
 * Return a themed breadcrumb trail.
 *
 * @param $breadcrumb
 *   An array containing the breadcrumb links.
 * @return
 *   A string containing the breadcrumb output.
 */
function wedia_breadcrumb($variables) {
	$breadcrumb = $variables['breadcrumb'];
	// Determine if we are to display the breadcrumb.
	$show_breadcrumb = 'yes';
	if (!drupal_is_front_page()) {
		// Return the breadcrumb with separators.
		if (!empty($breadcrumb)) {
			return $heading . '<div class="breadcrumb">' . theme('item_list',array('items'=>$breadcrumb,'type'=>'ul'))  . '</div>';
		}
	}
	
	// Otherwise, return an empty string.
	return '';
}

/**
 * Converts a string to a suitable html ID attribute.
 *
 * http://www.w3.org/TR/html4/struct/global.html#h-7.5.2 specifies what makes a
 * valid ID attribute in HTML. This function:
 *
 * - Ensure an ID starts with an alpha character by optionally adding an 'n'.
 * - Replaces any character except A-Z, numbers, and underscores with dashes.
 * - Converts entire string to lowercase.
 *
 * @param $string
 * 	The string
 * @return
 * 	The converted string
 */	
function wedia_id_safe($string) {
	// Replace with dashes anything that isn't A-Z, numbers, dashes, or underscores.
	$string = strtolower(preg_replace('/[^a-zA-Z0-9_-]+/', '-', $string));
	// If the first character is not a-z, add 'n' in front.
	if (!ctype_lower($string{0})) { // Don't use ctype_alpha since its locale aware.
		$string = 'id'. $string;
	}
	return $string;
}

/**
 * Generate the HTML output for a menu link and submenu.
 *
 * @param $variables
 *  An associative array containing:
 *   - element: Structured array data for a menu link.
 *
 * @return
 *  A themed HTML string.
 *
 * @ingroup themeable
 * 
 */
function wedia_menu_link(array $variables) {
	$element = $variables['element'];
	$sub_menu = '';

	if ($element['#below']) {
		$sub_menu = drupal_render($element['#below']);
	}
	$output = l($element['#title'], $element['#href'], $element['#localized_options']);
	// Adding a class depending on the TITLE of the link (not constant)
	$element['#attributes']['class'][] = wedia_id_safe($element['#title']);
	// Adding a class depending on the ID of the link (constant)
	$element['#attributes']['class'][] = 'mid-' . $element['#original_link']['mlid'];
	
	return '<li' . drupal_attributes($element['#attributes']) . '>' . $output . $sub_menu . "</li>\n";
}

/**
 * Override or insert variables into theme_menu_local_task().
 */
function wedia_preprocess_menu_local_task(&$variables) {
	$link =& $variables['element']['#link'];

	// If the link does not contain HTML already, check_plain() it now.
	// After we set 'html'=TRUE the link will not be sanitized by l().
	if (empty($link['localized_options']['html'])) {
		$link['title'] = check_plain($link['title']);
	}
	$link['localized_options']['html'] = TRUE;
	$link['title'] = '<span class="tab">' . $link['title'] . '</span>';
}

/**
 * Duplicate of theme_menu_local_tasks() but adds clearfix to tabs.
 */
function wedia_menu_local_tasks(&$variables) {  
	$output = '';

	if (!empty($variables['primary'])) {
		$variables['primary']['#prefix'] = '<h2 class="element-invisible">' . t('Primary tabs') . '</h2>';
		$variables['primary']['#prefix'] .= '<ul class="tabs primary clearfix">';
		$variables['primary']['#suffix'] = '</ul>';
		$output .= drupal_render($variables['primary']);
	}
	if (!empty($variables['secondary'])) {
		$variables['secondary']['#prefix'] = '<h2 class="element-invisible">' . t('Secondary tabs') . '</h2>';
		$variables['secondary']['#prefix'] .= '<ul class="tabs secondary clearfix">';
		$variables['secondary']['#suffix'] = '</ul>';
		$output .= drupal_render($variables['secondary']);
	}

	return $output;
}