(function ($) {

Drupal.behaviors.fieldPermissionsSettings = {
  attach: function (context) {
    // For user fields, we want the "Create own value for field X" permission
    // row to only be displayed when it's meaningful (i.e., when the "Display
    // on user registration form" checkbox is checked).
    var $user_register_form_checkbox, $required_field_checkbox, $create_permission_row;
    $user_register_form_checkbox = $('.form-item-instance-settings-user-register-form .form-checkbox', context);
    if ($user_register_form_checkbox.length) {
      // The "Required field" checkbox can cause the user registration checkbox
      // to change, so we need it also.
      $required_field_checkbox = $('.form-item-instance-required .form-checkbox', context);
      if ($required_field_checkbox.length) {
        // Get the permissions table row corresponding to the "Create own value
        // for field X" permission. The theme_user_admin_permissions() function
        // does not give us a good way to directly detect which row contains
        // the create permissions, so we have rely on the fact that it will be
        // the first row.
        $create_permission_row = $('table#permissions tbody tr', context).filter(':first');
        new Drupal.fieldPermissions.HideCreatePermission($user_register_form_checkbox, $required_field_checkbox, $create_permission_row);
      }
    }
  }
};

Drupal.fieldPermissions = {};

/**
 * Constructor for the HideCreatePermission object.
 *
 * This object hides and shows the "Create own value for field X" permission
 * for user fields when it is appropriate to do so, depending on the state of
 * the "Display on user registration form" and "Required field" checkboxes.
 */
Drupal.fieldPermissions.HideCreatePermission = function ($user_register_form_checkbox, $required_field_checkbox, $create_permission_row) {
  this.$user_register_form_checkbox = $user_register_form_checkbox;
  this.$create_permission_row = $create_permission_row;
  // Start off by making sure the create permission row has the correct
  // visibility.
  this.setCreatePermissionVisibility();
  // Set the row's visibility again whenever the user registration checkbox
  // changes, or when the required field checkbox (which controls it) changes.
  $user_register_form_checkbox.bind('change', $.proxy(this.setCreatePermissionVisibility, this));
  $required_field_checkbox.bind('change', $.proxy(this.setCreatePermissionVisibility, this));
};

/**
 * Set the correct visibility of the "Create own value for field X" permission.
 */
Drupal.fieldPermissions.HideCreatePermission.prototype.setCreatePermissionVisibility = function () {
  // Granting permissions for "Create own value for field X" only makes sense
  // when the field is configured to appear on the user registration form, so
  // only show the row in the permissions table then.
  if (this.$user_register_form_checkbox.is(':checked')) {
    this.$create_permission_row.show();
  }
  else {
    this.$create_permission_row.hide();
  }
};

})(jQuery);
