<?php

/**
 * @file media_akamai/includes/media_akamai.styles.inc
 * Styles definitions for Media: Akamai.
 */

/**
 * Implementation of Styles module hook_styles_register().
 */
function media_akamai_styles_register() {
  return array(
    'MediaAkamaiStyles' => array(
      'field_types' => 'file',
      'name' => t('MediaAkamai'),
      'description' => t('Media Akamai styles.'),
      'path' => drupal_get_path('module', 'media_akamai') .'/includes',
      'file' => 'media_akamai.styles.inc',
    ),
  );
}

/**
 *  Implements hook_styles_containers(). (Deprecated in version 2)
 */
function media_akamai_styles_containers() {
  return array(
    'file' => array(
      'containers' => array(
        'media_akamai' => array(
          'label' => t('Akamai Styles'),
          'data' => array(
            'streams' => array(
              'akamai',
            ),
            'mimetypes' => array(
              'video/akamai',
            ),
          ),
          'weight' => 0,
          'filter callback' => 'media_akamai_formatter_filter',
          'themes' => array(
            'field_formatter_styles' => 'media_akamai_field_formatter_styles',
            'styles' => 'media_akamai_styles',
            'preview' => 'media_akamai_preview_style',
          ),
          'description' => t('Akamai Styles will display embedded Akamai videos and thumbnails to your choosing, such as by resizing and autoplay. You can !manage.', array('!manage' => l(t('manage your Akamai styles here'), 'admin/config/media/media-akamai-styles'))),
        ),
      ),
    ),
  );
}

function media_akamai_formatter_filter($variables) {
  if (isset($variables['object'])) {
    $object = isset($variables['object']->file) ? $variables['object']->file : $variables['object'];
    return (file_uri_scheme($object->uri) == 'akamai') && ($object->filemime == 'video/akamai');
  }
}

/**
 * Implementation of the File Styles module's hook_file_styles_filter().
 */
function media_akamai_file_styles_filter($object) {
  $file = isset($object->file) ? $object->file : $object;
  if ((file_uri_scheme($file->uri) == 'akamai') && ($file->filemime == 'video/akamai')) {
    return 'media_akamai';
  }
}

/**
 *  Implements hook_styles_styles().
 */
function media_akamai_styles_styles() {
  $styles = array(
    'file' => array(
      'containers' => array(
        'media_akamai' => array(
          'styles' => array(
            'akamai_thumbnail' => array(
              'name' => 'akamai_thumbnail',
              'effects' => array(
                array('label' => t('Thumbnail'), 'name' => 'thumbnail', 'data' => array('thumbnail' => 1)),
                array('label' => t('Resize'), 'name' => 'resize', 'data' => array('width' => 100, 'height' => 75)),
              ),
            ),
            'akamai_preview' => array(
              'name' => 'akamai_preview',
              'effects' => array(
                array('label' => t('Autoplay'), 'name' => 'autoplay', 'data' => array('autoplay' => 0)),
                array('label' => t('Resize'), 'name' => 'resize', 'data' => array('width' => 220, 'height' => 165)),
              ),
            ),
            'akamai_full' => array(
              'name' => 'akamai_full',
              'effects' => array(
                array('label' => t('Autoplay'), 'name' => 'autoplay', 'data' => array('autoplay' => 0)),
                array('label' => t('Resize'), 'name' => 'resize', 'data' => array('width' => 640, 'height' => 480)),
                array('label' => t('Full screen'), 'name' => 'fullscreen', 'data' => array('fullscreen' => 1)),
              ),
            ),
          ),
        ),
      ),
    ),
  );

  // Allow any image style to be applied to the thumbnail.
  foreach (image_styles() as $style_name => $image_style) {
    $styles['file']['containers']['media_akamai']['styles']['akamai_thumbnail_' . $style_name] = array(
      'name' => 'akamai_thumbnail_' . $style_name,
      'image_style' => $style_name,
      'effects' => array(
        array('label' => t('Thumbnail'), 'name' => 'thumbnail', 'data' => array('thumbnail' => 1)),
      ),
    );
  }

  return $styles;
}

/**
 *  Implements hook_styles_presets().
 */
function media_akamai_styles_presets() {
  $presets = array(
    'file' => array(
      'square_thumbnail' => array(
        'media_akamai' => array(
          'akamai_thumbnail_square_thumbnail',
        ),
      ),
      'thumbnail' => array(
        'media_akamai' => array(
          'akamai_thumbnail',
        ),
      ),
      'small' => array(
        'media_akamai' => array(
          'akamai_preview',
        ),
      ),
      'large' => array(
        'media_akamai' => array(
          'akamai_full',
        ),
      ),
      'original' => array(
        'media_akamai' => array(
          'akamai_full',
        ),
      ),
    ),
  );
  return $presets;
}

/**
 * Implementation of Styles module hook_styles_default_containers().
 */
function media_akamai_styles_default_containers() {
  // We append Akamai to the file containers.
  return array(
    'file' => array(
      'containers' => array(
        'media_akamai' => array(
          'class' => 'MediaAkamaiStyles',
          'name' => 'media_akamai',
          'label' => t('Akamai'),
          'preview' => 'media_akamai_preview_style',
        ),
      ),
    ),
  );
}


/**
 * Implementation of Styles module hook_styles_default_presets().
 */
function media_akamai_styles_default_presets() {
  $presets = array(
    'file' => array(
      'containers' => array(
        'media_akamai' => array(
          'default preset' => 'unlinked_thumbnail',
          'styles' => array(
            'original' => array(
              'default preset' => 'video',
            ),
            'thumbnail' => array(
              'default preset' => 'linked_thumbnail',
            ),
            'square_thumbnail' => array(
              'default preset' => 'linked_square_thumbnail',
            ),
            'medium' => array(
              'default preset' => 'linked_medium',
            ),
            'large' => array(
              'default preset' => 'large_video',
            ),
          ),
          'presets' => array(
            'video' => array(
              array(
                'name' => 'video',
                'settings' => array(),
              ),
            ),
            'large_video' => array(
              array(
                'name' => 'resize',
                'settings' => array(
                  'width' => 640,
                  'height' => 390,
                ),
              ),
              array(
                'name' => 'video',
                'settings' => array(),
              ),
            ),
          ),
        ),
      ),
    ),
  );
  // Allow any image style to be applied to the thumbnail.
  foreach (image_styles() as $style_name => $image_style) {
    $presets['file']['containers']['media_akamai']['presets']['linked_' . $style_name] = array(
      array(
        'name' => 'linkToMedia',
        'settings' => array(),
      ),
      array(
        'name' => 'imageStyle',
        'settings' => array(
          'image_style' => $style_name,
        ),
      ),
      array(
        'name' => 'thumbnail',
        'settings' => array(),
      ),
    );
    $presets['file']['containers']['media_akamai']['presets']['unlinked_' . $style_name] = $presets['file']['containers']['media_akamai']['presets']['linked_' . $style_name];
    array_shift($presets['file']['containers']['media_akamai']['presets']['unlinked_' . $style_name]);
    foreach ($image_style['effects'] as $effect) {
      if (in_array($effect['name'], array('image_scale', 'image_scale_and_crop', 'image_resize', 'image_crop'))) {
        $presets['file']['containers']['media_akamai']['presets']['video_' . $style_name] = array(
          array(
            'name' => 'resize',
            'settings' => $effect['data'],
          ),
          array(
            'name' => 'video',
            'settings' => array(),
          ),
        );
      }
    }
  }
  return $presets;
}
