
/**
 * @file media_akamai/js/media_akamai.js
 */

(function ($) {

Drupal.media_akamai = {};
Drupal.behaviors.media_akamai = {
  attach: function (context, settings) {
    // Check the browser to see if it supports html5 video.
    var video = document.createElement('video');
  }
};

Drupal.media_akamai.needFlash = function () {
  var id = $(this).attr('id');
  var wrapper = $('.media-akamai-preview-wrapper');
  var hw = Drupal.settings.media_akamai[id].height / Drupal.settings.media_akamai[id].width;
  wrapper.html('<div class="js-fallback">' + Drupal.t('You need Flash to watch this video. <a href="@flash">Get Flash</a>', {'@flash':'http://get.adobe.com/flashplayer'}) + '</div>');
  wrapper.height(wrapper.width() * hw);
};

Drupal.media_akamai.insertEmbed = function (embed_id) {
  var videoWrapper = $('#' + embed_id + '.media-akamai-preview-wrapper');
  var settings = Drupal.settings.media_akamai[embed_id];

  // Calculate the ratio of the dimensions of the embed.
  settings.hw = settings.height / settings.width;

  // Replace the object embed with YouTube's iframe. This isn't done by the
  // theme function because YouTube doesn't have a no-JS or no-Flash fallback.
  var video = $('<iframe class="akamai-player" type="text/html" frameborder="0"></iframe>');
  var src = 'http://www.akamai.com/embed/' + settings.video_id;

  // Allow other modules to modify the video settings.
  settings.options = settings.options || {};
  settings.options.wmode = 'opaque';
  $(window).trigger('media_akamai_load', settings);

  // Merge YouTube options (such as autoplay) into the source URL.
  var query = $.param(settings.options);
  if (query) {
    src += '?' + query;
  }

  // Set up the iframe with its contents and add it to the page.
  video
    .attr('id', settings.id)
    .attr('width', settings.width)
    .attr('height', settings.height)
    .attr('src', src);
  videoWrapper.html(video);

  // Bind a resize event to handle fluid layouts.
  $(window).bind('resize', Drupal.media_akamai.resizeEmbeds);

  // For some reason Chrome does not properly size the container around the
  // embed and it will just render the embed at full size unless we set this
  // timeout.
  if (!$('.lightbox-stack').length) {
    setTimeout(Drupal.media_akamai.resizeEmbeds, 1);
  }
};

Drupal.media_akamai.resizeEmbeds = function () {
  $('.media-akamai-preview-wrapper').each(Drupal.media_akamai.resizeEmbed);
};

Drupal.media_akamai.resizeEmbed = function () {
  var context = $(this).parent();
  var video = $(this).children(':first-child');
  var hw = Drupal.settings.media_akamai[$(this).attr('id')].hw;
  // Change the height of the wrapper that was given a fixed height by the
  // YouTube theming function.
  $(this)
    .height(context.width() * hw)
    .width(context.width());

  // Change the attributes on the embed to match the new size.
  video
    .height(context.width() * hw)
    .width(context.width());
};

})(jQuery);