<?php 

function wextendedqueue_admin_view($queue, $subqueue = array()) {
  drupal_set_title(t("Nodequeue '@title'", array('@title' => $queue->title)), PASS_THROUGH);
  $qid = $queue->qid;

  // If the queue has just one subqueue, it gets special treatment.
  if (empty($subqueue->sqid)) {
    if ($queue->subqueues == 1) {
      $subqueues = nodequeue_load_subqueues_by_queue($queue->qid);
      $subqueue = array_shift($subqueues);
    }
    else {
      // display subqueue list page.
      return nodequeue_view_subqueues($queue);
    }
  }
  elseif ($subqueue->sqid) {
    if (!nodequeue_api_subqueue_access($subqueue, NULL, $queue)) {
      return drupal_not_found();
    }
    // Adjust properties of the page so our subqueue is in the right
    // visual place.
    drupal_set_title(t("Subqueue '@title'",
      array('@title' => nodequeue_title_substitute($queue->subqueue_title, $queue, $subqueue))), PASS_THROUGH);
    $breadcrumb = drupal_get_breadcrumb();
    $breadcrumb[] = l($queue->title, "admin/structure/nodequeue/$queue->qid");
    drupal_set_breadcrumb($breadcrumb);
  }
  return wextendedqueue_arrange_subqueue($queue, $subqueue);
}


function wextendedqueue_arrange_subqueue($queue, $subqueue = NULL) {
  // set title and load subqueue if it's not provided
  drupal_set_title(t("Nodequeue '@title'", array('@title' => $queue->title)), PASS_THROUGH);
  if (!$subqueue->sqid) {
    if ($queue->subqueues == 1) {
      $subqueues = nodequeue_load_subqueues_by_queue($queue->qid);
      $subqueue = array_shift($subqueues);
    }
    else {
      return drupal_not_found();
    }
  }
  elseif ($subqueue->sqid) {
    if (!nodequeue_api_subqueue_access($subqueue, NULL, $queue)) {
      return drupal_not_found();
    }
    drupal_set_title(t("Subqueue '@title'", array('@title' => nodequeue_title_substitute($queue->subqueue_title, $queue, $subqueue))), PASS_THROUGH);
  }

  
  $order = $queue->reverse ? 'DESC' : 'ASC';

  $visible = nodequeue_nids_visible($subqueue->sqid);

  // Get a list of all nodes in the subqueue, regardless of access restrictions.
  $query = db_select('node', 'n')
    ->distinct();

  $query->leftJoin('nodequeue_nodes', 'nq', 'nq.nid = n.nid');
  $query->fields('n', array('nid'))
    ->fields('nq', array('position'))
    ->condition('nq.sqid', $subqueue->sqid)
    ->orderBy('nq.position', $order);
  $result = $query->execute();

  $nids = array();
  $sq_nodes = array();
  $datenids = array();
  foreach ($result as $sq_node) {
    $nids[] = $sq_node->nid;
    // Save node position in a separate array so we can reference it later.
    $sq_nodes[$sq_node->nid]['position'] = $sq_node->position;
  }
  $nodes = node_load_multiple($nids);
  
  $nodes[] = (object) array('nid'=>0,'name'=> 'seperator');
  $sq_nodes[0]['position'] = 'r';

  $query = db_select('node', 'n');
  $query->fields('n', array('nid'));
  if(count($nids)){
    $query->condition('n.nid', $nids, 'NOT IN');
  }
  if(count($queue->types)){
    $query->condition('n.type',$queue->types,'IN');  
  }
  
  $stids = trim(str_replace(' ','',variable_get('wextendedqueue_'.$queue->qid.'_terms','')));
  if(strlen($stids)){
      if(strpos($stids,',')) {
          $or = db_or();
          $tids = explode(',',$stids);
          
      }
      else if(strpos($stids,'+')){  
          $tids = explode('+',$stids);
      }else{
          $tids = array($stids);
      }
      
      $query->leftJoin('taxonomy_index', 'ti', 'ti.nid = n.nid');

      if(isset($or)){
        foreach($tids as $tid){
             $or->condition('ti.tid',$tid,'=');
        }
        $query->condition($or);
      }else {
        $query->condition('ti.tid', $tids, 'IN');
      }
  }
  $query->groupBy('n.nid');  
  $query->orderBy('n.created', 'DESC');
  $result = $query->extend('PagerDefault')->limit(variable_get('wextendedqueue_'.$queue->qid.'_items',10))->execute();
  
  foreach ($result as $record) {
    $datenids[] = $record->nid; 
    $sq_nodes[$record->nid]['position'] = 'r';
  }
  
  
  
  if(count($datenids)){
     $datenodes = node_load_multiple($datenids);   
     $nodes = array_merge($nodes,$datenodes); 
  }
  
  
  
  foreach ($nodes as $node) {
    $node->identity = in_array($node->nid,$datenids) ? 'date' : 'queue';
    $node->visible = (isset($visible[$node->nid]) || $sq_nodes[$node->nid]['position'] ==  'r') ? TRUE : FALSE;
    $node->position = $sq_nodes[$node->nid]['position'];
    $node->queues = array();
    if(variable_get('wextendedqueue_'.$queue->qid.'_queue',0)==1){
         $query = db_select('nodequeue_queue', 'q');
         $query->leftJoin('nodequeue_nodes', 'n', 'q.qid = n.qid');
         $query->fields('q', array('qid','title'));
         $query->condition('n.nid', $node->nid);
         $query->condition('q.qid', $subqueue->sqid,'!=');
         $result = $query->execute();
         foreach ($result as $record) {
            $node->queues[] =l($record->title,'admin/structure/nodequeue/'.$record->qid.'/view/'.$record->qid.'/extended', array('attributes'=>array('target'=>'_blank')));
         }
    }
    
  }
  
  return drupal_get_form('wextendedqueue_arrange_subqueue_form', $queue, $nodes, $subqueue);

}

function wextendedqueue_arrange_subqueue_form($form, $form_state, $queue, $nodes, $subqueue) {
  $form = array('#tree' => TRUE);

  // Prepare the main part of the form which will be themed as a table.
  $count = count($nodes);
 
  $form['nodes'] = array();
  $form['nodes']['#theme'] = 'wextendedqueue_arrange_subqueue_form_table';

  // Theme function needs these.
  $form['nodes']['#queue']    = (array) $queue;
  $form['nodes']['#subqueue'] = (array) $subqueue;
 //dpm(language_types_info());
  if(variable_get('wextendedqueue_'.$queue->qid.'_lang',0)==1) $languages = language_list();
  foreach ($nodes as $node) {
    $selectednids[]= $node->nid;
    $form['nodes'][$node->nid]['#node'] = (array) $node;

    if ($node->visible && $node->nid !=0) {
      $queuestext = '';
      if(variable_get('wextendedqueue_'.$queue->qid.'_queue',0)==1 && count($node->queues)) $queuestext = '<br/><span>'.t('Also on').': '.implode(', ',$node->queues).'<span>';
      $form['nodes'][$node->nid]['#node'] = (array) $node;
      $form['nodes'][$node->nid]['title'] = array('#markup' => l($node->title, 'node/' . $node->nid).$queuestext);
      $form['nodes'][$node->nid]['author'] = array('#markup' => theme('username', array('account' => $node)));
      $form['nodes'][$node->nid]['date'] = array('#markup' => format_date($node->created, 'short'));
      if(variable_get('wextendedqueue_'.$queue->qid.'_type',0)==1) $form['nodes'][$node->nid]['type'] = array('#markup' =>  check_plain(node_type_get_name($node)));
      if(variable_get('wextendedqueue_'.$queue->qid.'_lang',0)==1){
          $langcode = entity_language('node', $node);
          if ($langcode == LANGUAGE_NONE || isset($languages[$langcode])) {
             $form['nodes'][$node->nid]['lang'] = array('#markup' => $langcode == LANGUAGE_NONE ? t('Language neutral') : t($languages[$langcode]->name));
          }
          else {
            $form['nodes'][$node->nid]['lang'] = array('#markup' => t('Undefined language (@langcode)', array('@langcode' => $langcode)));
          }
      }
      if(variable_get('wextendedqueue_'.$queue->qid.'_cat',0)==1) $form['nodes'][$node->nid]['cat'] = array('#markup' =>  wextendedqueue_show_category($node->nid,$queue->qid));
      
    }
    else {
      $form['nodes'][$node->nid]['title'] = array('#value' => t('Restricted node, NID: @nid', array('@nid' => $node->nid)));
      $form['nodes'][$node->nid]['author'] = array('#value' => '');
      $form['nodes'][$node->nid]['date'] = array('#value' => '');
    }

    if (node_access('update', $node) && $node->nid !=0) {
      $form['nodes'][$node->nid]['edit'] = array('#markup' => l(t('edit'), 'node/' . $node->nid . '/edit', array('attributes' => array('title' => t('Edit this node')))));
    }
    $form['nodes'][$node->nid]['position'] = array(
      '#type' => 'position',
      '#delta' => $count,
      '#default_value' =>  $node->position,
      '#attributes' => array(
        'class' => array('node-position'),
      ),
    );
  }


  $form['actions'] = array('#type' => 'actions');
  $form['actions']['submit'] = array(
    '#type' => 'submit',
    '#value' => t('Save'),
    '#submit' => array('wextendedqueue_arrange_subqueue_form_submit'),
  );
  
    $form['goto_page'] = array(
        '#type'=> 'hidden'
    );

  if ($count == 0) {
    $form['actions']['submit']['#disabled']  = TRUE;
  }

  return $form;
}

function wextendedqueue_arrange_subqueue_form_submit($form, &$form_state){
  
  $nodes = array();
  $maxpos = $form_state['values']['nodes'][0]['position'];
  foreach ($form_state['values']['nodes'] as $nid => $element) {
    if (is_numeric($nid)) {
      $pos = $form_state['values']['nodes'][$nid]['position'];  
      
      if($maxpos=='r') $condition = $pos != 'r';
      else if($form['nodes']['#queue']['reverse']==1) $condition = $pos > $maxpos;
      else $condition = $pos < $maxpos;
      
      if($condition){
          $nodes[$pos] = array(
            'nid' => $nid,
            'data' => $form_state['values']['nodes'][$nid]
          );
      }
    }
  }

  $message = 'The queue has been updated.';

  $qid  = $form['nodes']['#queue']['qid'];
  $sqid = $form['nodes']['#subqueue']['sqid'];

  include_once DRUPAL_ROOT . '/' . drupal_get_path('module', 'nodequeue') . '/includes/nodequeue.admin.inc';
  nodequeue_save_subqueue_order($nodes, $qid, $sqid);
  
  drupal_set_message(t('@message', array('@message' => $message)));
  if(strlen($form_state['values']['goto_page'])){
      
      $options = $form_state['values']['goto_page']==0 ? array() : array('query'=>array('page'=>$form_state['values']['goto_page'])); 
      drupal_goto(implode('/',arg()),$options);
  }
}

function wextendedqueue_show_category($nid,$qid){
    $vids = explode(',',str_replace(' ','',trim(variable_get('wextendedqueue_'.$qid.'_catid',' '))));
    if(count($vids) && $taxonomy = wextendedqueue_get_terms_from_node($nid)){
        $out = array();
        foreach($taxonomy as $vid => $terms){
            if(in_array($vid, $vids)){
                foreach($terms as $tid => $term){
                    $out[] = l($term['name'], 'taxonomy/term/'.$term['tid']);
                }
            }
        }
        
        if(sizeof($out)) return implode(', ',$out);
    }
    
    
}

function wextendedqueue_get_terms_from_node($nid){
    $terms = array();
    $qry = db_select('taxonomy_index','ti')
        ->fields('ti',array('tid'))
        ->fields('ttd',array('name'))
        ->fields('ttd',array('vid'))
        ->fields('tth',array('parent'));
    $qry->join('taxonomy_term_data','ttd','ti.tid = ttd.tid');
    $qry->join('taxonomy_term_hierarchy','tth','ti.tid = tth.tid');
    $qry->condition('ti.nid',$nid);
    $qry->orderBy('ttd.vid, tth.parent');
    $result = $qry->execute();
    while($row = $result->fetchAssoc()){
        $terms[$row['vid']][] = array(
            'tid' => $row['tid'],
            'name' => $row['name'],
            'parent' => $row['parent']
        );
    }
    if($terms) return $terms;
    else return false;
}


